/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.entangledfix.mixins;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com.supermartijn642.entangled.EntangledBlockTile"}, remap=false)
public abstract class EntangledBlockTileMixin {
    @Shadow
    private BlockPos pos;
    @Shadow
    private int callDepth;
    private BlockEntity phantomEntity;

    @Shadow
    protected abstract Level getDimension();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        this.phantomEntity = null;
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lcom/supermartijn642/entangled/EntangledBlockTile;getDimension()Lnet/minecraft/world/level/Level;", shift=At.Shift.AFTER)})
    private void tick2(CallbackInfo ci) {
        Level world = this.getDimension();
        if (world != null && world.m_46749_(this.pos)) {
            this.phantomEntity = world.m_7702_(this.pos);
        }
    }

    @Overwrite
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability) {
        return this.getCapability(capability, null);
    }

    @Nonnull
    @Overwrite
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (this.phantomEntity != null && this.callDepth <= 10 && !this.phantomEntity.m_58901_()) {
            ++this.callDepth;
            LazyOptional value = this.phantomEntity.getCapability(capability, facing);
            --this.callDepth;
            return value;
        }
        return LazyOptional.empty();
    }
}

